<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * ArticlesController
 * 
 * Handles the actions for artciles related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class PackageController extends Controller
{
    /**
     * List available published articles 
     */
	public function Init()
    {
		 if(Yii::app()->user->getId()=="")
		 {  
		     Yii::app()->user->setReturnUrl(Yii::app()->request->requestUri);
			 $this->redirect(Yii::app()->createUrl("user/signin"));
		 }
		 $this->getData('pageStyles')->add(array('src' => Yii::app()->baseUrl."/backend/assets/css/table2.css"));
		 $this->getData('pageStyles')->add(array('src' => AssetsUrl::css('tabs.css')));
		 $this->getData('pageStyles')->add(array('src' => AssetsUrl::css('tabstyles.css')));
	     $this->getData('pageScripts')->add(array('src' => AssetsUrl::js('modernizr.custom.js')));
	     $this->getData('pageScripts')->add(array('src' => AssetsUrl::js('cbpFWTabs.js')));
    }
    public function actionIndex()
    {
		
		$this->layout =   Yii::app()->LayoutClass->layoutpath("fullwidth"); 
		$model =  Package::model()->listData();
		
		 
		
     
        $this->setData(array(
            'pageMetaTitle'     =>Yii::app()->options->get('system.common.site_name').' | '.Yii::t('articles', 'Contact Us'), 
            'pageBreadcrumbs'   => array()
        )); 
        
					 
        $refenece_number='DF-' . uniqid();
        $hash = time();
        $this->render(Yii::app()->LayoutClass->viewpath("index"), compact('model','refenece_number','hash'));
    }
    
   
}
